import { Component, OnInit, Input } from '@angular/core';
import { MvpServices } from '../../../../services/mvp-services';
import { NgRedux, select } from 'ng2-redux';

@Component({
  selector: 'app-mvp-add-synonyms',
  templateUrl: './mvp-add-synonyms.component.html',
  styleUrls: ['./mvp-add-synonyms.component.scss']
})
export class MvpAddSynonymsComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
	@Input() mvpObject;
	@Input() synonym;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
  	public mvpServices: MvpServices) { }

  ngOnInit() {
  }

  addSynonymToMvpObject() {
    var synonymInput;
    if (this.synonym != null && this.synonym.length > 0) {
      synonymInput = this.synonym.trim();
    }
    if (synonymInput != null && synonymInput.length > 0) {
      this.mvpObject.object = synonymInput;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
